c    The subroutines in this file except the first one have been adapted from
c      the ANSR III computer program.
c                                            Sudip S.B./McGill/1992-93
c
c     -------------------------------------------------------------------EIGSOL
      subroutine eigsol (na,bigkd,f,neq,nsto,damp,keig,mtot,imass,
     +windo,t1)
      implicit double precision (a-h,o-z)
      dimension na(1),bigkd(1),f(1),windo(1)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c      call assemk (na,bigkd)
      kkdt=2+neq
      kdat=kkdt+keig
      mlast=(kdat-1)*2
      if (mlast .gt. mtot) then
         write (not,1001)
         keig=0
         return
      else
         call bakup (f,neq,-imass,windo)
      endif
      nsize=(mtot-mlast)/2
      call eigen (na,bigkd,f(1),neq,nsto,damp,keig,f(kkdt),f(kdat),
     + nsize)
c      call izero (bigkd(1),2*nsto)
      t1=f(kkdt)
      call izero (f(1),mtot)
c
 1001 format (' * Eigen analysis abandoned due to storage limitation *')
c
      return
      end
c     --------------------------------------------------------------------EIGEN
      subroutine eigen (na,bigkd,fmass,n,nds,damp,mf,prd,eldat,nsize)
      implicit double precision (a-h,o-z)
      logical afr,prt
      dimension na(n),bigkd(nds),fmass(n),eldat(nsize),prd(mf)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /integr/ dt,dto,dampm,dampkt,dampko,nsteps
      data ipr/2/
      data tol/1.d-9/
c
      neq = n
      mf=min0(mf,neq)
      mq = min0(mf+mf,mf+8,neq)
c
      mv = 1
      mt = mv + mq*neq*ipr
      mg = mt + neq*ipr
      mh = mg + mq*(mq+1)/2*ipr
      md = mh + mq*(mq+1)/2*ipr
      mdp= md + mq*ipr
      mdt= mdp+ mq*ipr
      mp = mdt+ mq*ipr
      mz = mp + mq*mq*ipr
c      ms = mz + mq*neq*ipr
c      msq = ms + neq*neq*ipr
      krlast=mz+mq*neq*ipr
      if (krlast .gt. nsize) then
          write (ntm,1002)
          write (not,1002)
          mf=0
          return
      else
c      write (ntm,1001) krlast,nsize
      write (not,1001) krlast,nsize
      endif
c
      pi = dacos(-1.d0)
c     subspace eigencomputations : set constraints.
c
      afr = .true.
      prt = .false.
      call numass(fmass,neq,mq,not)
      if(mq.lt.mf) write(not,2039) mq
      mf = min0(mf,mq)
      imas = 2
c      shift=0.d0
c     subspace iteration..
      call subsp(bigkd,fmass,eldat(mv),eldat(mt),eldat(mg),eldat(mh),
     1           eldat(md),eldat(mdp),eldat(mdt),eldat(mp),eldat(mz),
     2           na,mf,mq,neq,imas,tol,shift,prt,afr,25,not)
c.... print frame eigenvalues and corresponding periods.
      write(not,2907)
c      write(not,3002)
      t1 = 0
      t2 = 0
      do 54 ij = 1,mf
      wi2=eldat(md+ij-1)
      period = 2*pi/dsqrt(wi2)
      prd(ij)=period
      if(ij.eq.1) t1 = period
      if(ij.eq.2) t2 = period
  54  write(not,3000) ij,wi2,period
c.....calculate rayleigh damping coefficients.
      dampm  = 4*pi*damp/(t1+t2)
      dampkt = 0
      dampko = (t1*t2*damp)/pi/(t1+t2)
      funper = t1
      secper = t2
      write(not,2995) damp,dampm,dampkt,dampko
c.... print frame eigenvectors.
C      write(not,2990)
c      call mprint(not,eldat(mv),neq,mf,neq,8hegvector)
2907  format('EIGENVALUE ANALYSIS.')
2039  format(' number eigenvalues reduced to',i4,' by number of
     1nonzero lumped mass terms')
C 2990  format(/'FRAME EIGENVECTORS : these are orthogonal wrt to the mass
C      1 matrix')
2995  format(/'  damp   = ',e12.4,/,'  dampm = ',e12.4,/,
     1        '  dampkt = ',e12.4,/,' dampko = ',e12.4)
3000  format('mode',i2,'  w**2 =',e16.8,'  T =',e16.8,' sec')
c 3002  format(/'FRAME EIGENVALUES and modal periods.'/)
 1001 format (//' Required real storage for eigen solution:',i7/
     +' Available real storage                  :',i7)
 1002 format (' * Eigen analysis abandoned due to storage limitation *')
c
      return
      end
      subroutine numass(b,neq,mq,nfile)
      implicit double precision (a-h,o-z)
      dimension b(neq)
      nn = 0
      do 10 n = 1,neq
      if(b(n).ne.0.0d0) nn = nn + 1
10    continue
      if(nn.lt.mq) write(nfile,2000) nn
      mq = min0(mq,nn)
      return
2000  format(' subspace size reduced to',i4,' by number of nonzero lumpe
     1d mass terms')
      end
      subroutine subsp(a,b,v,t,g,h,d,dp,dtol,p,z,jdiag,nf,nv,
     1                 neq,imas,tol,shift,prt,afr,its,nfile)
c     ***************************************************************
c     subspace iteration to extract the lowest nf eigenpairs

c     called by : propre
c     call      : actcol,dzero
c
c    -arguments:
c i   a(nds)   : symmetric coefficient stiffness stored column-wise
c i   b( )     : rhs at call, solution X on return.
c     v(neq,1) :
c     t( )     :
c     g( )     : choleski factorization
c     h( )     : choleski factorization
c i   d(n)     : matrix of eigenvalues in subspace
c i   dp(n)    :
c i   dtol()   : matrix of current eigenvalue residuals.
c     p()      :
c     z()      :
c i   jdiag(n) : diagonals pointer array for s
c i   nf       :
c i   nv
c i   neq      : no of equations solved.
c     imas = 1 :
c          = 2 :
c     tol      :
c i   shift    : eigenvalue shift
c     prt      : logical, print
c     afr      : logical, if .true triangular decomposition performed.
c     its
c     nfile    : file no for output.

c     ***************************************************************
      implicit double precision (a-h,o-z)
      logical conv,prt,afr
      common/sturm/ neiglo
      save /sturm/
      dimension a(*),b(*),v(neq,*),t(*),g(*),h(*),d(*),dp(*),dtol(*),
     1          p(nv,*),z(neq,*),jdiag(*)

c.... apply shift to matrix if necessary

      if(shift.ne.0.0d0) call pshft(a,b,jdiag,shift,neq,imas,nfile)

c.... compute the triangular factors of 'a'

      if(afr) call actcol(a,v,jdiag,neq,afr,.false.,nfile)

      if(prt) write(nfile,2002) neiglo

c.... compute the initial iteration vectors

      call pzero(v,nv*neq)
      nomas = 0

      do 100 n = 1,neq
      it = jdiag(n)
      dm = b(n)
      if(imas.eq.1) dm = b(it)
      if(dm.ne.0.0d0) nomas = nomas + 1
100   continue
      nomas = nomas/nv
      i = 0
      j = 1

      do 110 n = 1,neq
      it = jdiag(n)
      dm = b(n)
      if(imas.eq.1) dm = b(it)
      if(dm.eq.0.0d0) go to 110
      v(n,j) = dm
      i = i + 1
      if(mod(i,nomas).eq.0) j = j + 1
      j = min0(j,nv)
110   continue
      do 120 i = 1,nv
      dp(i) = 0.0
      dtol(i) = 1.0d0
120   call scalev(v(1,i),neq)

c.... compute the new vectors and project 'a' onto 'g'

      conv = .false.
      if(tol.le.1.d-20) tol = 1.d-6
      itlim = its
      if(nv.eq.nf) itlim = 1
      do 300 it = 1,itlim
      itt = it

c.... project the 'b' matrix to form 'h' and compute 'z' vectors

      call sprojb(b,v,t,h,jdiag,neq,nv,imas)

c.... project the 'a' matrix to form 'g'

      call sproja(a,v,z,g,dtol,jdiag,neq,nv,nfile)

c.... solve the reduced eigenproblem 'g*p = h*p*d'

      call geig(g,h,d,p,t,nv,prt)

c.... check for convergence

      do 200 n = 1,nv
      if(d(n).ne.0.0d0)dtol(n) = dabs((d(n)-dp(n))/d(n))
200   dp(n) = d(n)
      if(prt) write(nfile,2000) it,(d(n),n=1,nv)
      if(prt.and.itlim.gt.1) write(nfile,2001) it,(dtol(n),n=1,nv)
      do 210 n = 1,nf
      if(dtol(n).gt.tol) go to 220
210   continue
      conv = .true.

c... divide eigenvectors by eigenvalue to prevent overflows

220   do 230 i = 1,nv
      div = d(i)
      if(p(i,i).lt.-0.00001d0) div = -div
      do 230 j = 1,nv
230   p(j,i) = p(j,i)/div

c.... compute the new iteration vector 'u' from 'z'

240   do 250 i = 1,neq
      do 250 j = 1,nv
      v(i,j) = 0.0d0
      do 250 k = 1,nv
250   v(i,j) = v(i,j) + z(i,k)*p(k,j)
      if(conv) go to 305
300   continue

c.... scale the vectors to have maximum element of 1.0

305   do 310 n = 1,nv
      d(n) = 1.0/d(n) + shift
310   if(n.le.nv) call scalev(v(1,n),neq)
      if(prt) write(nfile,2000) itt,(d(n),n=1,nv)
c      if(prt.and.tt.gt.1) write(nfile,2001) itt,(dtol(n),n=1,nv)
      if(prt.and.it.gt.1) write(nfile,2001) itt,(dtol(n),n=1,nv)
      return

c     format statements.

2000  format(/5x,'current eigenvalues, iteration',i4/(4d20.8))
2001  format(5x,'current residuals,   iteration',i4/(4d20.8))
2002  format(5x,'there are',i4,' eigenvalues less than the shift')
      end
      subroutine actcol(a,b,jdiag,neq,afac,back,nfile)
      implicit double precision (a-h,o-z)
      logical afac,back
      common /sturm/ neiglo
      dimension a(*),b(*),jdiag(*)
      parameter ( tol = 1.0e-7 )
c
c.... active column profile symmetric equation solver
c
c.... factor a to ut*d*u, reduce b
      aengy = 0.0
      nterm = jdiag(neq)
      neiglo = 0
      nops = neq
      jr = 0
      do 600 j = 1,neq
      jd = jdiag(j)
      jh = jd - jr
      is = j - jh + 2
      dg = a(jd)
      if(jh-2) 550,300,100
100   if(.not.afac) go to 500
      ie = j - 1
      k = jr + 2
      id = jdiag(is - 1)
c.... reduce all equations except diagonal
      do 200 i = is,ie
      ir = id
      id = jdiag(i)
      ih = min0(id-ir-1,i-is+1)
      if(ih.gt.0) a(k) = a(k) - xdot(a(k-ih),a(id-ih),ih)
      if(ih.gt.0) nops = nops + ih
200   k = k + 1
c.... reduce diagonal term
300   if(.not.afac) go to 500
      ir = jr + 1
      ie = jd - 1
      k = j - jd
      do 400 i = ir,ie
      id = jdiag(k+i)
      d = a(i)
      a(i) = a(i)*a(id)
      dg = dg - d*a(i)
400   continue
      nops = nops + 2*(ir-ie+1)
      if(dg*a(jd).lt.0.0d0) neiglo = neiglo + 1
      if(dg*a(jd).lt.0.0d0) write(nfile,2000) j
      if(dabs(dg).lt.tol*dabs(a(jd))) write(nfile,2001) j
      if(dg.eq.0.0d0) write(nfile,2002) j
c.... reduce rhs
500   if(back) b(j) = b(j) - xdot(a(jr+1),b(is-1),jh-1)
550   if(dg.ne.0.0d0.and.afac) a(jd) = 1./dg
600   jr = jd
      if(.not.back) go to 999
c.... divide by diagonal pivots
      do 700 i = 1,neq
      id = jdiag(i)
      dg = b(i)
      b(i) = b(i)*a(id)
700   aengy = aengy + b(i)*dg
c.... backsubstitute
      j = neq
      jd = jdiag(j)
800   d = b(j)
      j = j - 1
      if(j.le.0) go to 1100
      jr = jdiag(j)
      if(jd-jr.le.1) go to 1000
      is = j - jd + jr + 2
      k = jr - is + 1
      do 900 i = is,j
900   b(i) = b(i) - a(i+k)*d
1000  jd = jr
      go to 800
c 1100  if(pfr) write(nfile,2003) aengy
1100  write(nfile,2003) aengy
999   return
2000  format(' **warning 1** sign of equation',i5,' changed in actcol')
2001  format(' **warning 2** equation',i5,' lost at least 7 significant
     1 digits in actcol')
2002  format(' **warning 3** pivot of equation',i5,' is zero in actcol')
2003  format(' ** energy computed in actcol is',e18.10)
3000  format(' timing array output ',2f12.3)
      end
      subroutine geig(g,h,d,p,t,nv,prt)
      implicit double precision (a-h,o-z)
c
c.... solve the general eigenproblem 'g*p = h*p*d'
c
      logical prt
      dimension g(*),h(*),d(*),p(nv,*),t(*)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c.... compute the choleski factors of 'h'
c
      if(prt) call wprojm(g,nv,1,nfile)
      if(prt) call wprojm(h,nv,2,nfile)
      call chlfac(h,nv)
c
c.... compute the standard eigenvalue problem matrix 'c'
c
      call chlfwd(h,g,p,nv)
c
c.... perform the eignfunction decomposition of 'c'
c
      call eisql(g,d,t,p,nv,ir)
c
c.... compute the vectors of the original problem
c
      call chlbac(h,p,nv)
c      if(prt) call mprint(not,p,nv,nv,nv,9hvectors p)
      return
      end
      subroutine chlbac(u,s,nn)
      implicit double precision (a-h,o-z)
      dimension u(*),s(nn,nn)

c.... compute eigenvalues of general linear problem by backsubstitution
      j = nn
      jd = nn*(nn+1)/2
      do 100 i = 1,nn
100   s(nn,i) = s(nn,i)/u(jd)
200   jd = jd - j
      j = j - 1
      if(j.le.0) return
      do 300 i = 1,nn
      call colbac(u(jd+1),s(1,i),u(jd),j)
300   continue
      go to 200
      end
      subroutine colbac(u,s,d,jj)
      implicit double precision (a-h,o-z)
      dimension u(*),s(*)

c.... backsubstitution macro
      dd = s(jj+1)
      do 100 j = 1,jj
100   s(j) = s(j) - dd*u(j)
      s(jj) = s(jj)/d
      return
      end
      subroutine chlfac(a,nn)
      implicit double precision (a-h,o-z)
      dimension a(*)

c.... choleski factorization of a symmetric, positive definite matrix
      a(1) = dsqrt(a(1))
      if(nn.eq.1) return
      jd = 1
      do 200 j = 2,nn
      jm = j - 1
      id = 0
      do 100 i = 1,jm
      if(i-1.gt.0) a(jd+i) = a(jd+i) - xdot(a(id+1),a(jd+1),i-1)
      id = id + i
100   a(jd+i) = a(jd+i)/a(id)
      a(jd+j) = dsqrt(a(jd+j) - xdot(a(jd+1),a(jd+1),jm))
200   jd = jd + j
      return
      end
      subroutine chlfwd(u,g,s,nn)
      implicit double precision (a-h,o-z)
      dimension u(*),g(*),s(nn,nn)

c.... use the choleski factors to project onto a standard eigenproblem
      s(1,1) = g(1)/u(1)
      if(nn.eq.1) go to 300
      id = 1
      do 200 i = 2,nn
      s(1,i) = g(id+1)/u(1)
      im = i - 1
      jd = 0
      do 100 j = 1,im
      s(i,j) = (g(id+j) - xdot(u(id+1),s(1,j),im))/u(id+i)
      if(j.gt.1) s(j,i) = (g(id+j) - xdot(u(jd+1),s(1,i),j-1))/u(jd+j)
100   jd = jd + j
      id = id + i
200   s(i,i) = (g(id) - xdot(u(id-im),s(1,i),im))/u(id)

c.... complete projection

300   g(1) = s(1,1)/u(1)
      if(nn.eq.1) return
      jd = 2
      do 500 j = 2,nn
      g(jd) = s(j,1)/u(1)
      id = 2
      do 400 i = 2,j
      im = i - 1
      g(jd+im) = (s(j,i) - xdot(u(id),g(jd),im))/u(id+im)
400   id = id + i
500   jd = jd + j
      return
      end
      subroutine eisql(a,d,e,z,n,ierr)
      implicit double precision (a-h,o-z)
      dimension a(*),d(*),e(*),z(n,n)
      double precision machep
      data machep/0.13877788d-16/
c.... eispac ql algorithm adapted from 'tred2' and 'tql2'
      n2 = 0
      do 100 i = 1,n
      do 100 j = 1,i
      n2 = n2 + 1
100   z(i,j) = a(n2)
      if(n.eq.1) go to 320
      n2 = n + 2
      do 300 ii = 2,n
      i = n2 - ii
      l = i - 1
      h = 0.0d0
      scale = 0.0d0
      if(l.lt.2) go to 130
      do 120 k = 1,l
120   scale = scale + dabs(z(i,k))
      if(scale.ne.0.0d0) go to 140
130   e(i) = z(i,l)
      go to 290
140   do 150 k = 1,l
      z(i,k) = z(i,k)/scale
150   h = h + z(i,k)*z(i,k)
      f = z(i,l)
      g = -dsign(dsqrt(h),f)
      e(i) = scale*g
      h = h - f*g
      z(i,l) = f - g
      f = 0.0d0
      do 240 j = 1,l
      z(j,i) = z(i,j)/h
      g = 0.0d0
      do 180 k = 1,j
180   g = g + z(j,k)*z(i,k)
      jp1 = j + 1
      if(l.lt.jp1) go to 220
      do 200 k = jp1,l
200   g = g + z(k,j)*z(i,k)
220   e(j) = g/h
      f = f + e(j)*z(i,j)
240   continue
      hh = f/(h+h)
      do 260 j = 1,l
      f = z(i,j)
      g = e(j) - hh*f
      e(j) = g
      do 260 k = 1,j
260   z(j,k) = z(j,k) - f*e(k) - g*z(i,k)
290   d(i) = h
300   continue
c.... set transformation array for ql
320   d(1) = z(1,1)
      z(1,1) = 1.0d0
      e(1) = 0.0d0
      ierr = 0
      if(n.eq.1) go to 1001
      do 500 i = 2,n
      l = i - 1
      if(d(i).eq.0.0d0) go to 380
      do 360 j = 1,l
      g = 0.0d0
      do 340 k = 1,l
340   g = g + z(i,k)*z(k,j)
      do 360 k = 1,l
360   z(k,j) = z(k,j) - g*z(k,i)
380   d(i) = z(i,i)
      z(i,i) = 1.0d0
      do 400 j = 1,l
      z(i,j) = 0.0d0
400   z(j,i) = 0.0d0
500   continue
c.... begin 'ql' algorithm on tridagonal matrix now stored in 'd' and 'e'
      do 600 i = 2,n
600   e(i-1) = e(i)
      f = 0.0d0
      b = 0.0d0
      e(n) = 0.0d0
      do 840 l = 1,n
      j = 0
      h = machep*(dabs(d(l)) + dabs(e(l)))
      if(b.lt.h) b = h
      do 710 m = l,n
      if(dabs(e(m)).le.b) go to 720
710   continue
720   if(m.eq.l) go to 820
730   if(j.eq.30) go to 1000
      j = j + 1
      l1 = l + 1
      g = d(l)
      p = (d(l1)-g)/(e(l)+e(l))
      r = dsqrt(p*p+1.0d0)
      d(l) = e(l)/(p+dsign(r,p))
      h = g - d(l)
      do 740 i = l1,n
740   d(i) = d(i) - h
      f = f + h
      p = d(m)
      c = 1.0d0
      s = 0.0d0
      mml = m - l
      do 800 ii = 1,mml
      i = m - ii
      g = c*e(i)
      h = c*p
      if(dabs(p).lt.dabs(e(i))) go to 750
      c = e(i)/p
      r = dsqrt(c*c+1.0d0)
      e(i+1) = s*p*r
      s = c/r
      c = 1.0d0/r
      go to 760
750   c = p/e(i)
      r = dsqrt(c*c+1.0d0)
      e(i+1) = s*e(i)*r
      s = 1.0d0/r
      c = c*s
760   p = c*d(i) - s*g
      d(i+1) = h + s*(c*g + s*d(i))
      do 780 k = 1,n
      h = z(k,i+1)
      z(k,i+1) = s*z(k,i) + c*h
780   z(k,i  ) = c*z(k,i) - s*h
800   continue
      e(l) = s*p
      d(l) = c*p
      if(dabs(e(l)).gt.b) go to 730
820   d(l) = d(l) + f
840   continue
      do 900 ii = 2,n
      i = ii - 1
      k = i
      p = d(i)
      do 860 j = ii,n
      if(dabs(d(j)).le.dabs(p)) go to 860
      k = j
      p = d(j)
860   continue
      if(k.eq.i) go to 900
      d(k) = d(i)
      d(i) = p
      do 880 j = 1,n
      p = z(j,i)
      z(j,i) = z(j,k)
880   z(j,k) = p
900   continue
      go to 1001
1000  ierr = l
1001  return
      end
      subroutine mprint(nfile,a,ii,jj,mm,aname)
      implicit double precision (a-h,o-z)
      character aname * (*)
      dimension a(mm,*)
      nn = (jj+8)/9
      jb = 0
      do 100 n = 1,nn
      ja = jb + 1
      jd = jj-(ja+8)
      if (jd .le. 0) jb = jj
      if (jd .gt. 0) jb = ja+8
      write(nfile,2000) aname,(j,j=ja,jb)
      do 100 i=1,ii
      write(nfile,2001) i,(a(i,j),j=ja,jb)
  100 continue
      return
 2000 format(/5X,'matrix',A10//3X,'row/col',I8,8I11)
 2001 format(I6,4X,9E12.4)
      end
      subroutine wprojm(a,nn,ia,nfile)
      implicit double precision (a-h,o-z)
      dimension a(*)
      character ah(2)
      data ah(1),ah(2) /'g','h'/
      write(nfile,2000) ah(ia)
      i = 1
      do 100 n = 1,nn
      j = i + n - 1
      write(nfile,2001) (a(k),k=i,j)
100   i = i + n
      return
2000  format(' matrix ',a1)
2001  format(1p8d10.2)
      end
      subroutine pshft(a,b,jdiag,shift,neq,imas,nfile)
      implicit double precision (a-h,o-z)
      dimension a(*),b(*),jdiag(*)
      write(nfile,2000) shift
      go to (1,2), imas
c.... shift for consistent mass
1     nn = jdiag(neq)
      do 10 n = 1,nn
10    a(n) = a(n) - shift*b(n)
      return
c.... shift for lumped mass
2     do 20 n = 1,neq
      nn = jdiag(n)
20    a(nn) = a(nn) - shift*b(n)
      return
2000  format(' shift applied at',e12.4)
      end
      subroutine pzero(v,nn)
      implicit double precision (a-h,o-z)
c
c.... zero real array
c
      dimension v(nn)
      do 100 n = 1,nn
100   v(n) = 0.0
      return
      end
      subroutine scalev(v,nn)
      implicit double precision (a-h,o-z)
c
c.... scale a vector to have maximum element of 1.0
c
      dimension v(nn)
      vmax = dabs(v(1))
      do 100 n = 1,nn
100   vmax = dmax1(vmax,dabs(v(n)))
      do 110 n = 1,nn
110   v(n) = v(n)/vmax
      return
      end
      subroutine sproja(a,v,z,g,dtol,jdiag,neq,nv,nfile)
      implicit double precision (a-h,o-z)

c.... compute the subspace projection of 'a' to form 'g'
c
      dimension a(*),v(neq,*),z(neq,*),g(*),dtol(*),jdiag(*)
c.... forward reduce the eigenvector estimates
      icomp = 0
      do 400 i = 1,nv
      if(dtol(i).lt. 1.0d-12) go to 400
      icomp = icomp + 1
      jr = 1
      do 100 j = 1,neq
      jd = jdiag(j)
      jh = jd - jr
      z(j,i) = v(j,i)
      if(jh.le.0) go to 100
      is = j - jh
      z(j,i) = z(j,i) - xdot(a(jr),z(is,i),jh)
100   jr = jd + 1
c.... multiply by inverse of factored matrix diagonals
      do 200 j = 1,neq
      jd = jdiag(j)
200   z(j,i) =  z(j,i)*a(jd)
c.... perform the backsubstitution to get new vectors 'v'
      j = neq
      jd = jdiag(j)
300   if(j.le.1) go to 400
      jr = jdiag(j-1)
      jh = jd - jr -1
      if(jh.le.0) go to 320
      is = j - jh
      call pbacks(z(is,i),a(jr+1),z(j,i),jh)
320   j = j - 1
      jd = jr
      go to 300
400   continue
      ireuse = nv - icomp
      write(nfile,2000) icomp,ireuse
2000  format(' computed',i4,' new vectors, reused',i4,' old vectors')
c.... compute the projection of the stiffness
      k = 0
      do 500 j = 1,nv
      do 500 i = 1,j
      k = k + 1
500   g(k) = xdot(v(1,i),z(1,j),neq)
      return
      end
      subroutine pbacks(v,a,d,nn)
c
c...  backsubstitution macro
c
      implicit double precision (a-h,o-z)
      dimension v(nn),a(nn)
      do 100 n = 1,nn
100   v(n) = v(n) - a(n)*d
      return
      end
      subroutine sprojb(b,v,t,h,jdiag,neq,nv,imas)
      implicit double precision (a-h,o-z)
c
c.... compute the subspace projection of 'b' to form 'h'
c
      dimension b(*),v(neq,*),t(*),h(*),jdiag(*)
c.... compute 'z' and the 'b' projection to form 'h'
      do 110 j = 1,nv
c.... compute 'z' (consistent mass)
      go to (1,2), imas
c.... consistent mass
1     call pzero(t,neq)
      call promul(b,v(1,j),t,jdiag,neq,1.0d0)
      go to 3
c.... lumped mass
2     do 200 i = 1,neq
200   t(i) = v(i,j)*b(i)
c.... project the'z' and 'v' vectors to form 'h'
3     k = j*(j+1)/2
      do 100 i = j,nv
      h(k) = xdot(t,v(1,i),neq)
100   k = k + i
      do 110 i = 1,neq
110   v(i,j) = t(i)
      return
      end
      subroutine promul(a,b,c,jdiag,neq,const)
      implicit double precision (a-h,o-z)
      dimension a(*),b(*),c(*),jdiag(*)
      logical add
c
c.... routine to form c = c +/- a*b where a is a symmetric square matrix
c.... stored in profile form, b,c are vectors, and jdiag locates the
c.... diagonals in a.
c.... if "const" > 0.0d0 add to c, if "const" <= 0.0d0 subtract from c
c
      if(const.gt.0.0d0) add = .true.
      if(const.le.0.0d0) add = .false.
      js = 1
      do 200 j = 1,neq
      jd = jdiag(j)
      if(js.gt.jd) go to 200
      bj = b(j)
      ab = a(jd)*bj
      if(js.eq.jd) go to 150
      jb = j - jd
      je = jd - 1
      do 100 jj = js,je
      ab = ab + a(jj)*b(jj+jb)
      if(add) c(jj+jb) = c(jj+jb) + a(jj)*bj
      if(.not.add) c(jj+jb) = c(jj+jb) - a(jj)*bj
100   continue
150   if(add) c(j) = c(j) + ab
      if(.not.add) c(j) = c(j) - ab
200   js = jd + 1
      return
      end
      double precision function   xdot(a,b,n)
      implicit double precision (a-h,o-z)
      dimension a(*),b(*)
c
c.... vector dot product
c
      xdot = 0.0d0
      do 100 i = 1,n
100   xdot = xdot + a(i)*b(i)
      return
      end
